﻿var projects = {
    context: $(".v-projects"),
    datatable: null,
    treeview: null,
    getColumns: function () {
        var columns = [
            { "Title": resources.Id, "Data": "Id", "Visible": false, "Key": true, "Type": "numeric" },
            { "Title": resources.DatabaseId, "Data": "DatabaseId", "Visible": false, "Type": "numeric" },
            { "Title": resources.Name, "Data": "Name", "Class": "itemName", "HideInSelector": true, "Width": "20%" },
            { "Title": resources.Folder, "Data": "FolderName" },
            { "Name": "Status", "Title": resources.Status, "Data": "StatusEnum", "Class": "no-wrap", "Type": "enum", "EnumType": "SurveyStatus" },
            { "Title": resources.TotalCases, "Data": "Cases", "Type": "numeric" },
            { "Title": resources.Objective, "Data": "Objective", "Type": "numeric" },
            { "Title": resources.Completed, "Data": "Completed", "Type": "numeric" },
            { "Title": resources.Remaining, "Data": "Remaining", "Type": "numeric" },
            { "Title": resources.Modules, "Data": "ModulesCount", "Type": "numeric" },
            { "Title": resources.ActiveSessions, "Data": "ActiveSessions", "Type": "numeric", "Visible": false },
            { "Title": resources.ETBC, "Data": "ETBC", "Type": "numeric", "Visible": false },
            { "Title": resources.FreshSample, "Data": "FreshSample", "Type": "numeric" },
            { "Title": resources.CallBacks, "Data": "CallBacks", "Type": "numeric" },
            { "Title": resources.HoursSpent, "Data": "SpentHours", "Visible": false },
            { "Title": resources.EstimatedHoursLeft, "Data": "EstimatedHoursLeft", "Visible": false },
            { "Title": resources.AverageCompletionTime, "Data": "AverageTimeFormatted", "Name": "AverageTime" },
            { "Title": resources.StartDate, "Data": "StartDate", "Type": "date", "Visible": false },
            { "Title": resources.EndDate, "Data": "EndDate", "Type": "date", "Visible": false }]

        if (marketSightEnabled)
            columns.push({
                "Title": resources.VoxcoAnalytics, "Data": "PublishInMarketSight",
                "Type": "boolean", "Visible": false, "ShowIcon": true
            });

        return columns;
    },
    initializeDataTable: function (folder) {

        this.datatable = $(".h-projects-table", this.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getProjectAction("GetProjectStatistics", "Home"),
            ajaxParams: { "parentFolderId": folder ? folder.Id : 0 },
            columns: projects.getColumns(),
            stateKey: "Projects",
            allowRowSelection: true,
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return voxco.security.has('DELETE', data.Permissions) && data.Status == 1; } },
                { "Action": "stop", "Label": resources.Stop, "DisplayCondition": function (data) { return voxco.security.has('START_STOP', data.Permissions) && data.Status == 3; } },
                { "Action": "activate", "Label": resources.Activate, "DisplayCondition": function (data) { return voxco.security.has('START_STOP', data.Permissions) && data.Status == 1; } }
            ],
            contextMenuItems: [
                {
                    "Label": pagesResouces.Project_Modules,
                    "SubMenuItems": [
                        projects.createRedirectContextMenuItem("Index", "Modules", "voxco.security.has('READ', [Permissions]) && ([EnableCATI] || [EnableCAPI] || [EnableCAWI] || [EnableA4S] || [EnablePronto] || [EnableManual])"),
                        { "Action": "redirect", "Params": { action: "Edit", controller: "Questionnaire", area: "Survey" }, "Label": resources.WebSurvey, "DisplayCondition": function (data) { return voxco.security.has('READ', data.Permissions) && data.CanViewA4SQuestionnaire; } },
                        projects.createRedirectContextMenuItem("Index", "Simulation", "voxco.security.has('MODIFY', [Permissions]) && voxco.security.has('USE_INTERVIEW_SIMULATOR', [Permissions])"),
                        projects.createRedirectContextMenuItem("Index", "Tasks", "voxco.security.has('USE_TASKS', [Permissions])")
                    ]
                },
                {
                    "Label": pagesResouces.Project_Data,
                    "SubMenuItems": [
                        projects.createRedirectContextMenuItem("Browse", "Data", "voxco.security.has('READ', [Permissions]) && voxco.security.has('USE_DATA_BROWSER', [Permissions])"),
                        projects.createRedirectContextMenuItem("OpenEndCoding", "Data", "voxco.security.has('USE_DATA_CODIFICATION', [Permissions])"),
                        projects.createRedirectContextMenuItem("DataViews", "Data", "voxco.security.has('ACCESSTO_PROJECT_DATA_VIEW', [Permissions])"),
                        projects.createRedirectContextMenuItem("Index", "Importation", "voxco.security.has('USE_IMPORT', [Permissions])"),
                        projects.createRedirectContextMenuItem("Index", "Extraction", "voxco.security.has('USE_EXTRACT', [Permissions])"),
                        projects.createRedirectContextMenuItem("Index", "FilesManager", "hasPIIReadPermission && voxco.security.has('USE_FILEBROWSER', [Permissions])"),
                        { "Action": "analytics", "Label": resources.VoxcoAnalytics, "DisplayCondition": function (data) { return canAccessMarketSight && data.MarketSightDatasetId != null && data.MarketSightDatasetId != ""; } }
                    ]
                },
                {
                    "Label": pagesResouces.Project_Quotas,
                    "SubMenuItems": [
                        projects.createRedirectContextMenuItem("Index", "Quotas", "voxco.security.has('USE_QUOTA_DEF', [Permissions])"),
                        projects.createRedirectContextMenuItem("InterviewerQuotas", "Quotas", "[EnableCAPI] && voxco.security.has('USE_QUOTAS_PER_AGENT', [Permissions])"),
                        projects.createRedirectContextMenuItem("Schedules", "Quotas", "voxco.security.has('USE_QUOTA_SCH', [Permissions])"),
                        projects.createRedirectContextMenuItem("Roles", "Quotas", "voxco.security.has('MODIFY', [Permissions]) && [IsRole]==1")
                    ]
                },
                {
                    "Label": pagesResouces.Project_CallBacks,
                    "SubMenuItems": [
                        projects.createRedirectContextMenuItem("Index", "CallBacks", "voxco.security.has('USE_CB_ASGMNT', [Permissions])"),
                        projects.createRedirectContextMenuItem("Rules", "CallBacks", "voxco.security.has('USE_CB_RULES', [Permissions])"),
                        projects.createRedirectContextMenuItem("ExtendedRules", "CallBacks", "voxco.security.has('USE_CB_RULES_EX', [Permissions])"),
                        projects.createRedirectContextMenuItem("Shifts", "CallBacks", "voxco.security.has('USE_CB_SHIFTS', [Permissions])"),
                        projects.createRedirectContextMenuItem("TimeSlots", "CallBacks", "voxco.security.has('USE_CB_SLOTS', [Permissions])")
                    ]
                },
                {
                    "Label": pagesResouces.Project_Settings,
                    "SubMenuItems": [
                        projects.createRedirectContextMenuItem("Index", "Settings", "voxco.security.has('USE_FIELD_OPT', [Permissions])"),
                        projects.createRedirectContextMenuItem("CaseRestrictions", "Settings", "voxco.security.has('CASE_RESTRICTION_DEFINITION', [Permissions])"),
                        projects.createRedirectContextMenuItem("CallBacks", "Settings", "voxco.security.has('USE_CB_RULES', [Permissions]) || voxco.security.has('USE_CB_RULES_EX', [Permissions]) || voxco.security.has('USE_CB_SLOTS', [Permissions]) || voxco.security.has('USE_CB_SHIFTS', [Permissions]) || voxco.security.has('USE_CB_CALENDAR', [Permissions])"),
                        projects.createRedirectContextMenuItem("CATI", "Settings", "voxco.security.has('MODIFY', [Permissions]) && [EnableCATI]"),
                        projects.createRedirectContextMenuItem("CAPI", "Settings", "voxco.security.has('MODIFY', [Permissions]) && [EnableCAPI] && (voxco.security.has('USE_CAPI_MESSAGES', [Permissions]) || voxco.security.has('USE_QUOTAS_PER_AGENT', [Permissions]) || voxco.security.has('USE_CAPI_APPOINTMT_COLUMNS', [Permissions]))"),
                        projects.createRedirectContextMenuItem("CAWI", "Settings", "voxco.security.has('MODIFY', [Permissions]) && [EnableCAWI]"),
                        projects.createRedirectContextMenuItem("Pronto", "Settings", "voxco.security.has('MODIFY', [Permissions]) && ([EnablePronto] || [EnableManual])"),
                        projects.createRedirectContextMenuItem("Quota", "Settings", "voxco.security.has('USE_QUOTA_DEF', [Permissions])")
                    ]
                },
                {
                    "Label": pagesResouces.Project_Diagnostics,
                    "DisplayCondition": function (data) { return voxco.security.has('USE_INTWEBPROJECTLOGS', data.Permissions); },
                    "SubMenuItems": [
                        projects.createRedirectContextMenuItem("Index", "Diagnostics"),
                        projects.createRedirectContextMenuItem("CAWIConnectionsLogs", "Diagnostics", "[EnableCAWI]"),
                        projects.createRedirectContextMenuItem("CAPISyncHistory", "Diagnostics", "[EnableCAPI]"),
                        projects.createRedirectContextMenuItem("ErrorsLogs", "Diagnostics", "")
                    ]
                },
                { "Divider": true },
                { "Action": "copy", "Label": resources.Copy, "DisplayCondition": function (data) { return voxco.security.has('COPY', data.Permissions); } },
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return voxco.security.has('DELETE', data.Permissions) && data.Status == 1; } },
                { "Action": "properties", "Label": resources.Properties, "DisplayCondition": function (data) { return voxco.security.has('READ', data.Permissions); } },
                { "Divider": true, "DisplayCondition": function (data) { return voxco.security.has('START_STOP', data.Permissions); } },
                { "Action": "activate", "Label": resources.Activate, "DisplayCondition": function (data) { return voxco.security.has('START_STOP', data.Permissions) && data.Status == 1; } },
                { "Action": "stop", "Label": resources.Stop, "DisplayCondition": function (data) { return voxco.security.has('START_STOP', data.Permissions) && data.Status == 3; } },
                { "Divider": true },
                { "Action": "sampleInformation", "Label": resources.SampleInformation, "DisplayCondition": function (data) { return voxco.security.has('READ', data.Permissions); } }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "redirect":
                        if (data.params.action && data.params.controller) {
                            if (data.params.area == "Survey")
                                window.location = a4.getSurveyAction(data.params.action, data.params.controller, { surveyId: row.WebSurveyId });
                            else
                                window.location = a4.getProjectAction(data.params.action, data.params.controller, { projectId: row.Id });
                        }
                        break;
                    case "analytics":
                        window.open(a4.getProjectAction("Analytics", "Data", { projectId: row.Id }));
                        break;
                    case "copy":
                        modalDialog.showWindow(a4.getProjectAction("CopyProject", "Home", { projectId: row.Id, name: row.Name, folderNodeKey: projects.treeview.a4listview("getHighlightedNode").ListView_Internal_Key }), 500, 700, { afterClose: projects.refreshContent });
                        break;
                    case "delete":
                        projects.deleteProjects([row.Id], null);
                        break;
                    case "properties":
                        projects.displayProperties(false, row.Id);
                        break;
                    case "activate":
                        projects.startProjects(row.Id, row.Name, row.ModulesCount);
                        break;
                    case "stop":
                        projects.stopProjects(row.Id, row.Name, row.ModulesCount);
                        break;
                    case "sampleInformation":
                        projects.sampleInformation(row.Id);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");
                var names = _.pluck(rows, "Name");
                var modulesCount = _.reduce(_.pluck(rows, "ModulesCount"), function (memo, count) { return memo + count }, 0);

                switch (action) {
                    case "delete":
                        projects.deleteProjects(ids);
                        break;
                    case "stop":
                        projects.stopProjects(ids, names, modulesCount);
                        break;
                    case "activate":
                        projects.startProjects(ids, names, modulesCount);
                        break;
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.Stopped, "AjaxParams": { "status": 1 } },
                    { "Label": resources.Active, "AjaxParams": { "status": 3 } }
                ]
            },
            localizableTexts: { "All": resources.AllProjects, "Search": resources.SearchProjects },
            draw: function (event, data) {
                $(".h-actionsMenu", projects.context).toggle(data.totalRecords > 0);
            }
        });
    },
    createRedirectContextMenuItem: function (action, controller, displayCondition) {
        return {
            "Action": "redirect",
            "Params": { action: action, controller: controller },
            "Label": pagesResouces["Project_" + controller + "_" + action],
            "DisplayCondition": displayCondition
        };
    },
    initializeTreeView: function () {
        this.treeview = $(".h-projectFolders", this.context).a4listview({
            ajaxAction: a4.getProjectAction("GetProjectFolders", "Home"),
            stateKey: "Projects",
            draw: function (event, data) {
                var folder = data.selectedNode;

                if (projects.datatable) {
                    projects.datatable.a4datatable("option", "ajaxParams", { "parentFolderId": folder ? folder.Id : 0 });
                    projects.datatable.a4datatable("refresh");
                }
                else {
                    projects.initializeDataTable(folder);
                }

                if (folder)
                    projects.selectNodeCallback(folder);
            },
            selectNode: function (event, data) {
                projects.datatable.a4datatable("option", "ajaxParams", { "parentFolderId": data.node.Id });
                projects.datatable.a4datatable("refresh", true);

                projects.selectNodeCallback(data.node);
            },
            actionButtons: [
                { Action: "delete", Label: resources.Delete, Icon: "remove", DisplayCondition: function (data) { return voxco.security.has('DELETE_GROUP', data.Permissions) && data.Status == 1; } },
                { Action: "properties", Label: resources.Properties, Icon: "edit", DisplayCondition: function (data) { return voxco.security.has('READ_GROUP', data.Permissions) && data.ParentId > 0; } },
                { Action: "activate", Label: resources.Activate, Icon: "activate", DisplayCondition: function (data) { return voxco.security.has('START_STOP_GROUP', data.Permissions) && data.Status == 1; } },
                { Action: "stop", Label: resources.Stop, Icon: "deactivate", DisplayCondition: function (data) { return voxco.security.has('START_STOP_GROUP', data.Permissions) && data.Status == 3; } }
            ],
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;

                switch (action) {
                    case "activate":
                        projects.startFolder(node);
                        break;
                    case "stop":
                        projects.stopFolder(node);
                        break;
                    case "properties":
                        projects.displayProperties(true, node.Id);
                        break;
                    case "delete":
                        projects.deleteFolders(node);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchProjectFolders }
        });
    },
    selectNodeCallback: function (folder) {
        if (folder) {
            var menu = $("#main-header .h-new-project-menu", projects.context);

            var canCreateChild = voxco.security.has('CREATE', folder.Permissions);
            $(".h-new-project", menu).toggle(canCreateChild);

            var canCreateFolder = voxco.security.has('CREATE_GROUP', folder.Permissions);
            $(".h-new-project-folder", menu).toggle(canCreateFolder);

            menu.toggle(canCreateChild || canCreateFolder);
        }
    },
    bindEvents: function () {
        $(".h-new-project-menu").on("click", "li.h-new-project", function () {
            var selectedFolder = $(".h-projectFolders").a4listview("getHighlightedNode");

            var selectedFolderId = selectedFolder ? selectedFolder.Id : 0;

            modalDialog.showWindow(a4.getProjectAction("EditProject", "Home", { folderId: selectedFolderId }), 500, 850, { afterClose: projects.refreshContent });
        });

        $(".h-new-project-menu").on("click", "li.h-new-project-folder", function () {
            var selectedFolder = $(".h-projectFolders").a4listview("getHighlightedNode");

            var selectedFolderId = selectedFolder ? selectedFolder.Id : 0;

            modalDialog.showWindow(a4.getProjectAction("CreateFolder", "Home", { parentId: selectedFolderId }), 220, 600, { afterClose: projects.refreshContent });
        });

        projects.context.on("click", "li.h-export-excel-projects", function () {
            projects.exportExcel();
        });


        projectMenu.onAfterRefresh = projects.refreshContent;
    },
    selectedFolder: function () {
        var selectedFolder = $(".h-projectFolders").a4listview("getHighlightedNode");
        return selectedFolder ? selectedFolder.Id : 0;
    },
    deleteFolders: function (folder) {
        a4.callServerMethod(a4.getProjectAction("GetFolderModulesCount", "Home"), { folderId: folder.Id },
            function (result) {
                modalDialog.showConfirmDialog(
                    deleteFoldersResources,
                    function () {
                        a4.callServerMethod(a4.getProjectAction("DeleteFolders", "Home"), { folderIds: [folder.Id] },
                            function (result) {
                                projects.refreshContent();
                            }
                        );
                    },
                    null, null, true,
                    { "folder": folder.Name, "projectsCount": result.projectsCount, "modulesCount": result.modulesCount }
                );
            });
    },
    deleteProjects: function (projectIds) {
        modalDialog.showConfirmDelete(deleteProjectsResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteProjects", "Home"), { projectIds: projectIds },
                function (result) {
                    projects.refreshContent();
                });
        }, projectIds.length);
    },
    displayProperties: function (isFolder, id) {
        if (isFolder) {
            modalDialog.showWindow(a4.getProjectAction("FolderProperties", "Home", { id: id }), 250, 600, { afterClose: projects.refreshContent });
        }
        else {
            modalDialog.showWindow(a4.getProjectAction("EditProject", "Home", { id: id }), 480, 850, { afterClose: projects.refreshContent });
        }
    },
    refreshContent: function () {
        a4.hideBusyBox();
        projects.treeview.a4listview("refresh");
    },
    startFolder: function (folder) {
        a4.callServerMethod(a4.getProjectAction("GetFolderModulesCount", "Home"), { folderId: folder.Id }, function (result) {
            modalDialog.showConfirmDialog(confirmActivateFolderResources, function (applyProjectInsideFolder) {
                a4.callServerMethod(a4.getProjectAction("StartFolder", "Home"), { folderId: folder.Id, applyProjectInsideFolder: applyProjectInsideFolder }, function (result) {
                    projects.refreshContent();
                });
            }, null, null, false, { "folder": folder.Name, "projectsCount": result.projectsCount, "modulesCount": result.modulesCount }, { additionalCheckbox: true });
        });
    },
    stopFolder: function (folder) {
        a4.callServerMethod(a4.getProjectAction("GetFolderModulesCount", "Home"), { folderId: folder.Id }, function (result) {
            modalDialog.showConfirmDialog(confirmStopFolderResources, function () {
                a4.callServerMethod(a4.getProjectAction("StopFolder", "Home"), { folderId: folder.Id }, function (result) {
                    projects.refreshContent();
                });
            }, null, null, false, { "folder": folder.Name, "projectsCount": result.projectsCount, "modulesCount": result.modulesCount });
        });
    },
    startProjects: function (ids, names, modulesCount) {
        modalDialog.showConfirmDialog((ids.length > 1) ? confirmActivateProjectsResources : confirmActivateProjectResources, function () {
            a4.callServerMethod(a4.getProjectAction("StartProjects", "Home"), { projectIds: ids }, function (result) {
                projects.refreshContent();
                projects.datatable.a4datatable("refresh");
            });
        }, null, null, false, { "project": (ids.length > 1) ? names.length : names, "count": modulesCount });
    },
    stopProjects: function (ids, names, modulesCount) {
        modalDialog.showConfirmDialog((ids.length > 1) ? confirmStopProjectsResources : confirmStopProjectResources, function () {
            a4.callServerMethod(a4.getProjectAction("StopProjects", "Home"), { projectIds: ids }, function (result) {
                projects.datatable.a4datatable("refresh");
            });
        }, null, null, false, { "project": (ids.length > 1) ? names.length : names, "count": modulesCount });
    },
    sampleInformation: function (id) {
        modalDialog.showWindow(a4.getProjectAction("SampleInformation", "Home", { projectId: id }), 650, 750);
    },
    exportExcel: function () {
        var columns = projects.datatable.a4datatable("getVisibleColumns");
        var tableParams = projects.datatable.a4datatable("getTableParams");

        var params = {
            folderId: projects.selectedFolder(),
            columns: columns.join(),
            status: tableParams.QuickFilter ? tableParams.QuickFilter.status : null
        };

        a4.showBusyBox();

        a4.callServerMethod(a4.getProjectAction("ExportProject", "Home"), params, function (result) {
            a4.hideBusyBox();

            window.location = a4.getProjectAction("GetProjectFile", "Home", { filePath: result, fileName: "Projects.xlsx" });
        });
    }
}

$(document).ready(function () {
    if (projects.context.length > 0) {
        projects.initializeTreeView();
        projects.bindEvents();
    }

    if (typeof hasExpirationNotification !== 'undefined' && hasExpirationNotification && (!sessionStorage.getItem('notificationClosed') || sessionStorage.getItem('notificationClosed') == 'false')) {
        $("#header-container").css("top", "40px");
        $("#main-header").css("top", "98px");
        $("#main").css("margin-top", "40px");

    }

    $("#license-expiration-bar-close").click(function () {
        sessionStorage.setItem('notificationClosed', 'true');
        $("#license-expiration-bar").hide();
        $("#header-container").css("top", "0px");
        $("#main-header").css("top", "58px");
        $("#main").css("margin-top", "0px");

    });
});